ORCA/M Asm65816 2.1.0

0001 7DB1                       title 'Desk Manager--NDA Calls' 
0002 7DB1              **********************************************************************
0003 7DB1              *
0004 7DB1              * Desk Manager  
0005 7DB1              * for the Apple II GS
0006 7DB1              *
0007 7DB1              * original CDA code by John Worthinton.
0008 7DB1              * original NDA code by Steven Glass
0009 7DB1              *
0010 7DB1              * Additions and alterations by Steven Glass and
0011 7DB1              * Konstantin Othmer
0012 7DB1              *
0013 7DB1              * 5.x work by Harry Yee and Mensch
0014 7DB1              *
0015 7DB1              * System 6.0 work by Dave Lyons
0016 7DB1              *
0017 7DB1              * This file contains
0018 7DB1              *
0019 7DB1              *                   SystemEvent
0020 7DB1              *                   CheckNDAStuff
0021 7DB1              *                   CallCDAMenu
0022 7DB1              *                   InstallNDA
0023 7DB1              *                   OpenNDA
0024 7DB1              *                   CloseNDA
0025 7DB1              *                   CloseNDAByWinPtr
0026 7DB1              *                   CloseAllNDAs2
0027 7DB1              *                   DoCloseStuff
0028 7DB1              *                   SystemTask
0029 7DB1              *                   SystemClick
0030 7DB1              *                   SystemEdit
0031 7DB1              *                   FixAppleMenu2
0032 7DB1              *                   GetNumNDAs
0033 7DB1              *                   DeskUtils
0034 7DB1              *                   FindThisWindow
0035 7DB1              *                   AreWeTop
0036 7DB1              *                   SendAction
0037 7DB1              *                   SendOpen
0038 7DB1              *                   SendClose
0039 7DB1              *                   SendInit
0040 7DB1              *                   StartNDACall
0041 7DB1              *                   EndNDACall
0042 7DB1              *                   AddToRunQ
0043 7DB1              *                   RemoveFromRunQ
0044 7DB1              *                   ExecuteRunItem
0045 7DB1              *                   RemoveNDA
0046 7DB1              *                   GetDeskAccInfo      DAL
0047 7DB1              *                   CallDeskAcc         DAL
0048 7DB1              *                   GetDeskGlobal       DAL
0049 7DB1              *
0050 7DB1              **********************************************************************
0051 7DB1
0052 7DB1              **********************************************************************
0053 7DB1              *                                                                    *
0054 7DB1              *                   Copyright (C) 1985-1989                          *
0055 7DB1              *                   All Rights Reserved                              *
0056 7DB1              *                   Apple Computer, Inc.                             *
0057 7DB1              *                                                                    *
0058 7DB1              **********************************************************************
0059 7DB1
0060 7DB1
0061 7DB1              **********************************************************************
0062 7DB1              *
0063 7DB1              * Change History
0064 7DB1              *
0065 7DB1              * 20..25-Nov-90     Dave Lyons
0066 7DB1              *
0067 7DB1              * Changed FixAppleMenu (procedure now named FixAppleMenu2) to insert
0068 7DB1              * the NDA items in alphabetical order if bit 0 of battery RAM location
0069 7DB1              * $5F is set.
0070 7DB1              * Put back all.macros.
0071 7DB1              *
0072 7DB1              * 27-Nov-90         Dave Lyons
0073 7DB1              *
0074 7DB1              * Made sorting ignore leading blanks (GetNamePointer skips past them).
0075 7DB1              *
0076 7DB1              * 30-Nov-90         Dave Lyons
0077 7DB1              *
0078 7DB1              * Changed CompareTwo to return CLC for equal names, so it doesn't hang
0079 7DB1              * if there are two identically-named NDAs.
0080 7DB1              *
0081 7DB1              * 3-Jan-90          Dave Lyons
0082 7DB1              *
0083 7DB1              * Changed SystemEvent so that Apple-w or Apple-W with a System
0084 7DB1              * window in front calls CloseNDAByWinPtr and returns TRUE, instead
0085 7DB1              * of letting the DA or the application handle the Apple-W.
0086 7DB1              *
0087 7DB1              * 19-Feb-91         Dave Lyons
0088 7DB1              *
0089 7DB1              * Changed FindThisWindow to examine the Aux Wind Info & fetch an
0090 7DB1              * NDA Structure pointer from there.  This works pretty dang well!
0091 7DB1              * Didn't have to modify the other things that call it.
0092 7DB1              *
0093 7DB1              * New call GetDeskGlobal.  For selector 0, returns the pointer of
0094 7DB1              * the last window the Desk Manager examined.  Other selectors return
0095 7DB1              * error $0520.
0096 7DB1              *
0097 7DB1              * 11-Mar-91         Dave Lyons
0098 7DB1              *
0099 7DB1              * Implementing GetDeskAccInfo and CallDeskAcc.
0100 7DB1              *
0101 7DB1              * 17-Apr-91         Dave Lyons
0102 7DB1              *
0103 7DB1              * Removed GetWKind call from SystemEvent; now I look directly at the
0104 7DB1              * window record instead, since GetWKind was changing some Window Mgr
0105 7DB1              * direct page stuff.  This was very bad if SystemEvent got called
0106 7DB1              * from within a window manager call, and it was making DragWindow
0107 7DB1              * always drag the front window!
0108 7DB1              *
0109 7DB1              * 21-Apr-91         Dave Lyons
0110 7DB1              *
0111 7DB1              * Changed SystemTask to return with no error if GS/OS is busy.
0112 7DB1              * Changed SystemClick to honor the qContent bit of a system window
0113 7DB1              * (if set, click is passed to the NDA after it is selected).
0114 7DB1              *
0115 7DB1              * 2-May-91          Dave Lyons
0116 7DB1              *
0117 7DB1              * After CloseAllNDAs closes true NDAs, now it goes through open
0118 7DB1              * windows closing any remaining system windows (by calling
0119 7DB1              * CloseNDAByWinPtr).
0120 7DB1              *
0121 7DB1              * 10-May-91         Dave Lyons
0122 7DB1              *
0123 7DB1              * Fixed CloseAllNDAs logic so that getting an error on CloseNDAByWinPtr
0124 7DB1              * on a non-NDA system window does not cause an infinite loop!  This
0125 7DB1              * was causing a hang with Video Keyboard open.
0126 7DB1              *
0127 7DB1              * 4-Jul-91          Dave Lyons
0128 7DB1              *
0129 7DB1              * Modified SystemClick so the first thing is does is offer to let the
0130 7DB1              * NDA handle the event completely, by calling CallDeskAcc with action
0131 7DB1              * code 10.
0132 7DB1              *
0133 7DB1              * 24-Jul-91         Dave Lyons
0134 7DB1              *
0135 7DB1              * FixAppleMenu calls SendRequest($051E=systemSaysFixedAppleMenu) after
0136 7DB1              * it's done.
0137 7DB1              *
0138 7DB1              * 9-Aug-91          Dave Lyons
0139 7DB1              *
0140 7DB1              * OpenNDA now preserves the current port and sets the "standard" QD
0141 7DB1              * port.
0142 7DB1              *
0143 7DB1              * 16-Sep-91         Dave Lyons
0144 7DB1              *
0145 7DB1              * FixAppleMenu now checks RealDeskStatus to see if we're started up;
0146 7DB1              * if not, it tries DeskStartUp.  If we're *still* not started up, then
0147 7DB1              * no NDA items are added to the Apple menu.
0148 7DB1              *
0149 7DB1              * 17-Sep-91         Dave Lyons
0150 7DB1              *
0151 7DB1              * Small changes to support moving calls into Tool.Setup.
0152 7DB1              *
0153 7DB1              * 11-Oct-91         Dave Lyons
0154 7DB1              *
0155 7DB1              * Added a WindStatus check in the Command-W handling.
0156 7DB1              *
0157 7DB1              * 9-Nov-91          Dave Lyons
0158 7DB1              *
0159 7DB1              * Changed default minimum-size for a system window (when the system
0160 7DB1              * calls GrowWindow) to width=78, height=34.
0161 7DB1              *
0162 7DB1              * 4-Dec-91          Dave Lyons
0163 7DB1              *
0164 7DB1              * When SystemClick handles a click on a non-front system window that has
0165 7DB1              * the fQContent bit set, after the window comes to the front SystemClick
0166 7DB1              * calls FindWindow to see what part of the window the click is really in.
0167 7DB1              * (To see the result, try clicking in the close box of a not-in-front system
0168 7DB1              * window with the fQContent bit set, like Control Panels 2.0 or an individual
0169 7DB1              * control panel window.  Now it closes.  Before, the event got passed to the
0170 7DB1              * system window's Action routine, which was not prepared to handle it.
0171 7DB1              * Typically it just called TaskMasterDA, which would track the close box, but
0172 7DB1              * nobody would close the window.)
0173 7DB1              *
0174 7DB1              * 12-Dec-91         Dave Lyons
0175 7DB1              *
0176 7DB1              * When SystemEvent sees a Command-W and a system window is in front, it
0177 7DB1              * now uses CallDeskAcc to pass action $000B, giving the NDA a chance to
0178 7DB1              * handle the key itself before forcibly calling CloseNDAbyWinPtr.
0179 7DB1              *
0180 7DB1              **********************************************************************
0181 7DB1              *
0182 7DB1              * 26-Jun-92         Dave Lyons for 6.0.1
0183 7DB1              *
0184 7DB1              * Changed SendAction to allow stack-based action rouines.  If you set
0185 7DB1              * bit 31 of the action routine pointer, we push the stuff on the stack
0186 7DB1              * so you can write in Pascal or whatever.
0187 7DB1              *
0188 7DB1              *   function MyActionProc(code: integer; data:long): integer;
0189 7DB1              *
0190 7DB1              * 2-Jul-92          Dave Lyons
0191 7DB1              *
0192 7DB1              * When you OpenNDA sees the NDA is already open (has a window pointer),
0193 7DB1              * it tries sending a CallDeskAcc(reOpenAction=$000C).  If the DA takes
0194 7DB1              * that and puts a $0001 in the word pointed to by XY, OpenNDA takes no
0195 7DB1              * further action (otherwise it calls SelectWindow).
0196 7DB1              *
0197 7DB1              **********************************************************************
0198 7DB1
0199 7DB1                       include 'all.macros' 
0200 7DB1
0201 7DB1                       include '::sys.equs.asm' 
0202 7DB1                       include 'Desk.Equates.asm' 
0203 7DB1                       include 'e16.memory' 
0204 7DB1
0205 7DB1
0206 7DB1              ****************************************************************
0207 7DB1              *
0208 7DB1              * OpenNDA
0209 7DB1              *
0210 7DB1              *     Input     ID : word
0211 7DB1              *     Output    Refnum
0212 7DB1              *
0213 7DB1              *
0214 7DB1              * Stack looks like:
0215 7DB1              *
0216 7DB1              *      Space For Output
0217 7DB1              *      ID of NDA to open
0218 7DB1              *      =================
0219 7DB1              *                         <- SP
0220 7DB1              *
0221 7DB1              *
0222 7DB1              * The menu manager reserves menu item IDs 1 to 255 for
0223 7DB1              * the system.  I use 1 through NumNDAs for the IDs of
0224 7DB1              * desk accessories.  When an application wants to open
0225 7DB1              * an NDA, it just calls OpenNDA with the item ID returned
0226 7DB1              * from the menu manager.
0227 7DB1              *
0228 7DB1              * Change History
0229 7DB1              *
0230 7DB1              * 02 Oct 87         Steven Glass
0231 7DB1              *
0232 7DB1              * Changes were made here to use the new structure of the 
0233 7DB1              * NDAGlobals record.
0234 7DB1              *
0235 7DB1              * In addition, I changed the error exit and normal exit
0236 7DB1              * routines to share code.
0237 7DB1              *
0238 7DB1              *
0239 7DB1              * 16 Jun 88         Steven Glass
0240 7DB1              *
0241 7DB1              * If the NDA returns a NIL window pointer I do not mark it as 
0242 7DB1              * being open.  This allows DAs to be modal dialogs and 
0243 7DB1              * not be tricky when trying to close.
0244 7DB1              *
0245 7DB1              ****************************************************************
0246 7DB1              OpenNDA  PROC EXPORT 
0247 7DB1
0248 7DB1                       DSect OrigDirect+2 
0249 7DB1              RTL1     block 3 
0250 7DB1              RTL2     block 3 
0251 7DB1              ID       word 
0252 7DB1              Result   word 
0253 7DB1
0254 7DB1 20 FE 81              jsr   StartNDACall
0255 7DB4
0256 7DB4 20 BE 81              jsr   DerefNDAList
0257 7DB7
0258 7DB7 A5 21                 lda   ID
0259 7DB9 3A                    dec   a
0260 7DBA C7 01                 cmp   [NDAListPtr]
0261 7DBC 90 03                 bcc   @GotIt
0262 7DBE 82 F8 00              brl   NotFound
0263 7DC1
0264 7DC1 48           @GotIt   pha                            ; space for result
0265 7DC2 48                    pha                            ; (2 words)
0266 7DC3 48                    pha                            ; one less the id of this one
0267 7DC4 F4 24 00              PushWord #NDARecSize 
0268 7DC7 A2 0B 09 22           _Multiply 
0269 7DCE
0270 7DCE 68                    pla                            ; take result of multply and
0271 7DCF FA                    plx                            ; add in the size of the globals
0272 7DD0 18                    clc                            ; at the beginning of the handle.
0273 7DD1 69 0E 00              adc   #SizeOfDeskGlobals
0274 7DD4
0275 7DD4 85 23                 sta   Result                   ; use this result as the ref num
0276 7DD6
0277 7DD6
0278 7DD6              ;----------------------------------------------------
0279 7DD6              ;
0280 7DD6              ; Fix the PtrToThisOne variable using offset just
0281 7DD6              ; calculated.
0282 7DD6              ;
0283 7DD6 18                    clc   
0284 7DD7 65 01                 adc   NDAListPTr
0285 7DD9 85 09                 sta   PtrToThisOne
0286 7DDB A5 03                 lda   NDAListPtr+2
0287 7DDD 90 01                 bcc   NoCarry
0288 7DDF 1A                    inc   a
0289 7DE0 85 0B        NoCarry  sta   PtrToThisOne+2
0290 7DE2
0291 7DE2 A7 09                 lda   [PtrToThisOne]           ; look at status flags
0292 7DE4 F0 44                 beq   OpenIt                   ; if zero then not open yet
0293 7DE6
0294 7DE6              ;----------------------------------------------------
0295 7DE6              ;
0296 7DE6              ; The DA is already open, so we go and select it.
0297 7DE6              ;
0298 7DE6
0299 7DE6              *** added 2-Jul-92 DAL -- But first, let it handle its own re-open if it wants to
0300 7DE6 A9 00 00              lda   #0
0301 7DE9 8F 28 81 02           sta   >@handledReOpen
0302 7DED 48                    pha                            ;space for CallDeskAcc result
0303 7DEE F4 01 00              pea   $0001                    ;call NDA Action routine by window pointer
0304 7DF1 A0 1C 00              ldy   #o_WindowPtr+2
0305 7DF4 B7 09                 lda   [PtrToThisOne],y
0306 7DF6 48                    pha   
0307 7DF7 88                    dey   
0308 7DF8 88                    dey   
0309 7DF9 B7 09                 lda   [PtrToThisOne],y
0310 7DFB 48                    pha   
0311 7DFC F4 0C 00              pea   $000C                    ;action code = handle re-open
0312 7DFF F4 02 00              pea   @handledReOpen>>16
0313 7E02 F4 28 81              pea   @handledReOpen
0314 7E05 A2 05 24 22           _CallDeskAcc 
0315 7E0C FA                    plx                            ;discard
0316 7E0D AF 28 81 02           lda   >@handledReOpen
0317 7E11 D0 12                 bne   @handled
0318 7E13              *** end 2-Jul-92
0319 7E13
0320 7E13 A0 1C 00              ldy   #o_WindowPtr+2
0321 7E16 B7 09                 lda   [PtrToThisOne],y
0322 7E18 48                    pha   
0323 7E19 88                    dey   
0324 7E1A 88                    dey   
0325 7E1B B7 09                 lda   [PtrToThisOne],y
0326 7E1D 48                    pha   
0327 7E1E A2 0E 11 22           _SelectWindow 
0328 7E25 82 82 00     @handled brl   AllDone
0329 7E28
0330 7E28 00 00        @handledReOpen DC W:0
0331 7E2A
0332 7E2A              ;----------------------------------------------------
0333 7E2A              ;
0334 7E2A              ; The DA is not open, so we get it opened.
0335 7E2A              ;
0336 7E2A 20 BC 84     OpenIt   jsr   SetResID
0337 7E2D
0338 7E2D              *** added 9-Aug-91 DAL -- save the port and set a safe one!
0339 7E2D 48                    pha   
0340 7E2E 48                    pha   
0341 7E2F A2 04 1C 22           _GetPort 
0342 7E36
0343 7E36 48                    pha   
0344 7E37 48                    pha   
0345 7E38 F4 00 00              pea   0
0346 7E3B F4 04 00              pea   4
0347 7E3E A2 01 0C 22           _GetWAP 
0348 7E45 FA                    plx   
0349 7E46 68                    pla   
0350 7E47              ; Look at $10A on QD Direct page to find the Handle to the First Port
0351 7E47 BF 0C 01 00           lda   >$10A+2,x
0352 7E4B 48                    pha   
0353 7E4C BF 0A 01 00           lda   >$10A,x
0354 7E50 48                    pha   
0355 7E51 0B                    phd   
0356 7E52 3B                    tsc   
0357 7E53 5B                    tcd   
0358 7E54 A0 02 00              ldy   #2
0359 7E57 B7 03                 lda   [3],y
0360 7E59 AA                    tax   
0361 7E5A A7 03                 lda   [3]
0362 7E5C 85 03                 sta   <3
0363 7E5E 86 05                 stx   <5                       ;dereferenced into Port Pointer
0364 7E60 2B                    pld   
0365 7E61 A2 04 1B 22           _SetPort 
0366 7E68              *** end of 9-Aug-91 DAL
0367 7E68
0368 7E68 F4 00 00 F4           PushLong #0                    ; put room on stack
0369 7E6E 22 05 85 02           jsl   SendOpen                 ; call the open routine
0370 7E72
0371 7E72 A3 01                 lda   1,s                      ; if pointer is zero, do nothing more.
0372 7E74 03 03                 ora   3,s
0373 7E76 D0 04                 bne   @1
0374 7E78 68                    pla   
0375 7E79 68                    pla   
0376 7E7A 80 24                 bra   NoWindow
0377 7E7C              @1        
0378 7E7C
0379 7E7C A0 1A 00              ldy   #o_WindowPtr             ; put result in windowPtr field
0380 7E7F 68                    pla   
0381 7E80 97 09                 sta   [PtrToThisOne],y
0382 7E82 C8                    iny   
0383 7E83 C8                    iny   
0384 7E84 68                    pla   
0385 7E85 97 09                 sta   [PtrToThisOne],y
0386 7E87
0387 7E87 A9 00 80              lda   #$8000                   ; make status word indicate this is
0388 7E8A 87 09                 sta   [PtrToThisOne]           ; open.
0389 7E8C
0390 7E8C 48                    pha                            ; Init the last serviced field 
0391 7E8D 48                    pha   
0392 7E8E A2 03 25 22           _GetTick 
0393 7E95 A0 16 00              ldy   #o_LastServiced
0394 7E98 68                    pla   
0395 7E99 97 09                 sta   [PtrToThisOne],y
0396 7E9B C8                    iny   
0397 7E9C C8                    iny   
0398 7E9D 68                    pla   
0399 7E9E 97 09                 sta   [PtrToThisOne],y
0400 7EA0
0401 7EA0              NoWindow  
0402 7EA0              *** added 9-Aug-91 DAL -- restore the port
0403 7EA0 A2 04 1B 22           _SetPort 
0404 7EA7              *** end of 9-Aug-91 DAL
0405 7EA7 20 E7 84              jsr   RepResID
0406 7EAA
0407 7EAA              ;----------------------------------------------------
0408 7EAA              ;
0409 7EAA              ; All done, so clean up.
0410 7EAA
0411 7EAA A2 00 00     AllDone  ldx   #0
0412 7EAD DA           JoinExit phx   
0413 7EAE 20 DC 81              jsr   UnlockNDAList
0414 7EB1 FA                    plx   
0415 7EB2 20 12 82              jsr   EndNDACall
0416 7EB5
0417 7EB5 5C 39 7F 02           jml   oErrOut2
0418 7EB9
0419 7EB9 A2 10 05     NotFound ldx   #DANotFound
0420 7EBC 80 EF                 bra   JoinExit
0421 7EBE
0422 7EBE
0423 7EBE                       ENDP 
0424 7EBE
0425 7EBE
0426 7EBE
0427 7EBE                       title 'Desk Manager--desk/DESK.UTILS' 
0428 7EBE              ;               copy desk/desk.utils
0429 7EBE              ****************************************************************
0430 7EBE              *
0431 7EBE              * Desk Utility Routines
0432 7EBE              *
0433 7EBE              * Change History
0434 7EBE              *
0435 7EBE              * 02 Oct 87         Steven Glass
0436 7EBE              *
0437 7EBE              * Changes were made to get these to work with new global data
0438 7EBE              * structures.  The DerefNDAHandle routine no longer
0439 7EBE              * locks the handle (we assume that it is already locked)
0440 7EBE              *
0441 7EBE              * UnlockNDAHandle was removed (it was never called).
0442 7EBE              *
0443 7EBE              * A number of start/end's were combined into one.
0444 7EBE              *
0445 7EBE              *
0446 7EBE              ****************************************************************
0447 7EBE              DeskUtils PROC EXPORT 
0448 7EBE
0449 7EBE              ;----------------------------------------------------
0450 7EBE              ;
0451 7EBE              ; DerefNDAList
0452 7EBE              ;
0453 7EBE              ; Locks the NDAListHandle and deref's it into
0454 7EBE              ; NDAListPtr
0455 7EBE
0456 7EBE
0457 7EBE                       EXPORT DerefNDAList 
0458 7EBE              DerefNDAList  
0459 7EBE AF 6E 1D E0           lda   >EntryCount
0460 7EC2 1A                    inc   a
0461 7EC3 8F 6E 1D E0           sta   >EntryCount
0462 7EC7
0463 7EC7 A0 04 00              ldy   #4
0464 7ECA B7 15                 lda   [NDAListHandle],y
0465 7ECC 09 00 80              ora   #$8000                   ;lock the handle
0466 7ECF 97 15                 sta   [NDAListHandle],y
0467 7ED1 88                    dey   
0468 7ED2 88                    dey   
0469 7ED3 B7 15                 lda   [NDAListHandle],y
0470 7ED5 85 03                 sta   NDAListPtr+2
0471 7ED7 A7 15                 lda   [NDAListHandle]
0472 7ED9 85 01                 sta   NDAListPtr
0473 7EDB
0474 7EDB 60                    rts   
0475 7EDC
0476 7EDC              ;----------------------------------------------------
0477 7EDC              ;
0478 7EDC              ; UnlockNDAList
0479 7EDC              ;
0480 7EDC              ; Unlocks the NDAList handle.
0481 7EDC
0482 7EDC                       EXPORT UnlockNDAList 
0483 7EDC AF 6E 1D E0  UnlockNDAList lda   >EntryCount
0484 7EE0 3A                    dec   a
0485 7EE1 8F 6E 1D E0           sta   >EntryCount
0486 7EE5 D0 0A                 bne   LeaveItLocked
0487 7EE7
0488 7EE7 A0 04 00              ldy   #4
0489 7EEA B7 15                 lda   [NDAListHandle],y
0490 7EEC 29 FF 7F              and   #$7FFF
0491 7EEF 97 15                 sta   [NDAListHandle],y
0492 7EF1
0493 7EF1 60           LeaveItLocked rts   
0494 7EF2
0495 7EF2              ;----------------------------------------------------
0496 7EF2              ;
0497 7EF2              ; DerefNDAHandle
0498 7EF2              ;
0499 7EF2              ; Derefs but does not bother locking the handle to
0500 7EF2              ; the NDA.
0501 7EF2              ;
0502 7EF2
0503 7EF2                       EXPORT DerefNDAHandle  
0504 7EF2 A0 02 00     DerefNDAHandle ldy   #2
0505 7EF5 B7 0D                 lda   [NDAHandle],y
0506 7EF7 85 13                 sta   NDAPtr+2
0507 7EF9 A7 0D                 lda   [NDAHandle]
0508 7EFB 85 11                 sta   NDAPtr
0509 7EFD 60                    rts   
0510 7EFE
0511 7EFE                       ENDP 
0512 7EFE
0513 7EFE
0514 7EFE              ****************************************************************
0515 7EFE              *
0516 7EFE              * StartNDACall
0517 7EFE              *
0518 7EFE              * Inputs:
0519 7EFE              *    A-reg:  Low word of WAP value
0520 7EFE              *    Y-reg:  High word of WAP value
0521 7EFE              *
0522 7EFE              * Outputs
0523 7EFE              *    D-reg:  set to place on stack
0524 7EFE              *    b-reg:  set to code bank (k)
0525 7EFE              *    a-reg, x-reg and y-reg are trashed.
0526 7EFE              *
0527 7EFE              * Side Effects:
0528 7EFE              *
0529 7EFE              *    busy flag is incremented.
0530 7EFE              *
0531 7EFE              *
0532 7EFE              * This routine sets up direct page, adjusts the stack and
0533 7EFE              * data bank, calls IncBusyFlag in preperation for the
0534 7EFE              * start of a NDA Calls.
0535 7EFE              *
0536 7EFE              * It also leaves the WAP value (the handle to the global
0537 7EFE              * data structure) in the NDAListHandle field on direct page.
0538 7EFE              *
0539 7EFE              *
0540 7EFE              *
0541 7EFE              * Change History
0542 7EFE              *
0543 7EFE              * 02 Oct 87         Steven Glass
0544 7EFE              *
0545 7EFE              * Changes were necessary to support the new data structures.  The
0546 7EFE              * A & Y registers contain the WAP value for this tool.
0547 7EFE              *
0548 7EFE              ****************************************************************
0549 7EFE              StartNDACall PROC EXPORT 
0550 7EFE
0551 7EFE FA                    plx                            ; get rts adr in x
0552 7EFF
0553 7EFF 0B                    phd                            ; save direct reg
0554 7F00
0555 7F00 5A                    phy                            ; this is the handle to the
0556 7F01 48                    pha                            ; global data structure.
0557 7F02
0558 7F02 3B                    tsc                            ; and get my zero page off stack
0559 7F03 38                    sec   
0560 7F04 E9 14 00              sbc   #StdZPSize-4
0561 7F07 1B                    tcs   
0562 7F08 5B                    tcd   
0563 7F09
0564 7F09 8B                    phb                            ; save data bank
0565 7F0A 4B                    phk                            ; set data bank to
0566 7F0B AB                    plb                            ; code bank
0567 7F0C
0568 7F0C
0569 7F0C 22 64 00 E1           jsl   IncBusyFlg
0570 7F10
0571 7F10 DA                    phx                            ; put rts adr back on stack
0572 7F11 60                    rts   
0573 7F12
0574 7F12                       ENDP 
0575 7F12
0576 7F12
0577 7F12
0578 7F12
0579 7F12              ****************************************************************
0580 7F12              *
0581 7F12              * EndNDACall
0582 7F12              *
0583 7F12              * Inputs:
0584 7F12              *     None
0585 7F12              *
0586 7F12              * Outputs:
0587 7F12              *     None, but the x-register is preserved!
0588 7F12              *
0589 7F12              * This routine restores direct page and data bank, and adjusts
0590 7F12              * the stack and calls DecBusyFlg to undo everything that 
0591 7F12              * StartNDACall did.
0592 7F12              *
0593 7F12              *
0594 7F12              *
0595 7F12              * Change History
0596 7F12              *
0597 7F12              * 02 Oct 87         Steven Glass
0598 7F12              *
0599 7F12              * Changes were made to support the new data structures.  This 
0600 7F12              * routine now undoes everything done by the StartNDACall including
0601 7F12              * the busyflag and the direct page.
0602 7F12              *
0603 7F12              ****************************************************************
0604 7F12              EndNDACall PROC EXPORT 
0605 7F12
0606 7F12 7A                    ply                            ; save rts adr in y
0607 7F13
0608 7F13 AB                    plb                            ; restore data bank
0609 7F14 3B                    tsc                            ; adjust stack
0610 7F15 18                    clc   
0611 7F16 69 18 00              adc   #StdZPSize
0612 7F19 1B                    tcs   
0613 7F1A
0614 7F1A 2B                    pld                            ; restore direct page
0615 7F1B
0616 7F1B
0617 7F1B 5A                    phy                            ; put rts back on stack
0618 7F1C
0619 7F1C 22 68 00 E1           jsl   DecBusyFlg
0620 7F20
0621 7F20 60                    rts   
0622 7F21
0623 7F21                       ENDP 
0624 7F21
0625 7F21
0626 7F21              ****************************************************************
0627 7F21              *
0628 7F21              * CheckNDAStuff
0629 7F21              *
0630 7F21              * We look at the event type.  For certain events I pass them
0631 7F21              * to the Active DA.  For others, I do not.
0632 7F21              *
0633 7F21              ****************************************************************
0634 7F21                       EXPORT CheckNDAStuff 
0635 7F21              CheckNDAStuff PROC 
0636 7F21
0637 7F21 2B                    pld                            ; restore direct page
0638 7F22 68                    pla                            ; get WAP values back in A & Y
0639 7F23 7A                    ply   
0640 7F24 68                    pla   
0641 7F25 7A                    ply   
0642 7F26 28                    plp                            ; restore interrupt state
0643 7F27
0644 7F27 5A                    phy   
0645 7F28 48                    pha   
0646 7F29 5A                    phy   
0647 7F2A 48                    pha   
0648 7F2B 0B                    phd   
0649 7F2C 3B                    tsc   
0650 7F2D 5B                    tcd   
0651 7F2E
0652 7F2E
0653 7F2E              ;-------------------------------------------------
0654 7F2E              ;
0655 7F2E              ; Direct page equates until StartNDACall is made.
0656 7F2E              ;
0657 7F2E
0658 7F2E                       DefineStack 
0659 7F2E              OrigD    word 
0660 7F2E              DAPtr    long 
0661 7F2E              DAHandle long 
0662 7F2E              sret1    block 3 
0663 7F2E              sret2    block 3 
0664 7F2E              swhat    word 
0665 7F2E              smessage long 
0666 7F2E              swhen    long 
0667 7F2E              swhere   long 
0668 7F2E              smods    word 
0669 7F2E              sresult  word 
0670 7F2E
0671 7F2E              *** added 3-Jan-91 DAL--Apple-W handled by the system
0672 7F2E A5 11                 lda   <sWhat
0673 7F30 C9 05 00              cmp   #$0005                   ; is it auto key down?
0674 7F33 F0 05                 beq   @isKey
0675 7F35 C9 03 00              cmp   #$0003                   ; is it a key down?
0676 7F38 D0 14                 bne   @toDoSysEvent
0677 7F3A A5 1F        @isKey   lda   <sMods
0678 7F3C 29 00 01              and   #$0100                   ; see if the apple key is down...
0679 7F3F F0 7F                 beq   @DoSysEvent
0680 7F41
0681 7F41 A5 13                 lda   <sMessage
0682 7F43 29 FF 00              and   #$00ff
0683 7F46 C9 77 00              cmp   #'w'
0684 7F49 F0 05                 beq   @DoCloseNDA
0685 7F4B C9 57 00              cmp   #'W'
0686 7F4E D0 70        @toDoSysEvent bne   @DoSysEvent
0687 7F50
0688 7F50              @DoCloseNDA  
0689 7F50
0690 7F50              *** added 11-Oct-91 DAL -- if Window Manager not here, leave
0691 7F50 F4 00 00              pea   0
0692 7F53 A2 0E 06 22           _WindStatus 
0693 7F5A 68                    pla   
0694 7F5B F0 63                 beq   @DoSysEvent
0695 7F5D              *** end 11-Oct-91
0696 7F5D
0697 7F5D 48                    pha   
0698 7F5E 48                    pha   
0699 7F5F A2 0E 15 22           _FrontWindow 
0700 7F66 7A                    ply   
0701 7F67 68                    pla   
0702 7F68 D0 05                 bne   @aWindow
0703 7F6A BB                    tyx   
0704 7F6B D0 02                 bne   @aWindow
0705 7F6D 80 51                 bra   @DoSysEvent
0706 7F6F
0707 7F6F 48           @aWindow pha   
0708 7F70 48                    pha   
0709 7F71 5A                    phy   
0710 7F72 A2 0E 4C 22           _GetSysWFlag 
0711 7F79 68                    pla   
0712 7F7A 10 44                 bpl   @DoSysEvent
0713 7F7C
0714 7F7C              *** added 12-Dec-91 DAL -- give smart NDAs a chance to handle the fascist Command-W
0715 7F7C A9 00 00              lda   #0
0716 7F7F 8F BE 82 02           sta   >@sysEventBlock
0717 7F83
0718 7F83 F4 00 00              pea   0                        ;space for CallDeskAcc result
0719 7F86 F4 01 00              pea   $0001                    ;call NDA Action routine by window pointer
0720 7F89 48                    pha   
0721 7F8A 48                    pha                            ;space for window pointer
0722 7F8B A2 0E 15 22           _FrontWindow 
0723 7F92 F4 0B 00              pea   $000B                    ;action code = handle Command-W
0724 7F95 F4 02 00              pea   @sysEventBlock>>16
0725 7F98 F4 BE 82              pea   @sysEventBlock
0726 7F9B A2 05 24 22           _CallDeskAcc 
0727 7FA2 FA                    plx                            ;discard
0728 7FA3 AF BE 82 02           lda   >@sysEventBlock          ;nonzero = NDA handled it
0729 7FA7 D0 10                 bne   @exitTrue
0730 7FA9              *** end 12-Dec-91
0731 7FA9
0732 7FA9 48                    pha   
0733 7FAA 48                    pha   
0734 7FAB A2 0E 15 22           _FrontWindow 
0735 7FB2 A2 05 1C 22           _CloseNDAByWinPtr 
0736 7FB9
0737 7FB9 A9 FF FF     @exitTrue lda   #$ffff                  ;result = TRUE
0738 7FBC 80 2A                 bra   StoreResult
0739 7FBE
0740 7FBE 00 00        @sysEventBlock DC W:0                   ;12-Dec-91 DAL
0741 7FC0
0742 7FC0              @DoSysEvent  
0743 7FC0              *** end of 3-Jan-91 DAL addition
0744 7FC0
0745 7FC0 A5 11                 lda   swhat
0746 7FC2 0A                    asl   a                        ; double the event type
0747 7FC3 AA                    tax                            ; and put in x for later
0748 7FC4
0749 7FC4 A7 07                 lda   [DAHandle]
0750 7FC6 85 03                 sta   DAPtr
0751 7FC8 A0 02 00              ldy   #2
0752 7FCB B7 07                 lda   [DAHandle],y
0753 7FCD 85 05                 sta   DAPtr+2
0754 7FCF A0 02 00              ldy   #o_ActiveFlag
0755 7FD2 B7 03                 lda   [DAPtr],y
0756 7FD4 D0 05                 bne   WeAreActive
0757 7FD6
0758 7FD6 A9 00 00              lda   #0
0759 7FD9 80 0D                 bra   NeverMind
0760 7FDB
0761 7FDB E0 12 00     WeAreActive cpx   #18
0762 7FDE 90 05                 bcc   ValidEvent
0763 7FE0 A9 00 00              lda   #0
0764 7FE3 80 03                 bra   NeverMind
0765 7FE5
0766 7FE5 FC F3 82     ValidEvent jsr   (EventTable,x)
0767 7FE8
0768 7FE8              NeverMind  
0769 7FE8 85 21        StoreResult sta   sResult
0770 7FEA
0771 7FEA 2B                    pld                            ; clean up the stack
0772 7FEB 68                    pla   
0773 7FEC 68                    pla   
0774 7FED 68                    pla   
0775 7FEE 68                    pla   
0776 7FEF 5C EC 7E 02           jml   oEndCall16
0777 7FF3
0778 7FF3
0779 7FF3 13 83        EventTable DC W:Ignore                  ; 0  null events
0780 7FF5 13 83                 DC W:Ignore                    ; 1  mouse down
0781 7FF7 37 83                 DC W:DoIfWants                 ; 2  mouse upt
0782 7FF9 17 83                 DC W:DoIfWantsKey              ; 3  key down
0783 7FFB 37 83                 DC W:DoIfWants                 ; 4  undefined
0784 7FFD 37 83                 DC W:DoIfWants                 ; 5  auto key down
0785 7FFF 83 83                 DC W:DoUpdate                  ; 6  update
0786 8001 13 83                 DC W:Ignore                    ; 7  undefined
0787 8003 83 83                 DC W:DoActivate                ; 8  activate
0788 8005 13 83                 DC W:Ignore                    ; 9  switch event
0789 8007 13 83                 DC W:Ignore                    ; 10 desk acc
0790 8009 13 83                 DC W:Ignore                    ; 11 device driver
0791 800B 13 83                 DC W:Ignore                    ; 12 Ap
0792 800D 13 83                 DC W:Ignore                    ; 13
0793 800F 13 83                 DC W:Ignore                    ; 14
0794 8011 13 83                 DC W:Ignore                    ; 15
0795 8013
0796 8013
0797 8013              ;-------------------------------------------------
0798 8013              ;
0799 8013              ; Equates for direct page after the startNDACall
0800 8013              ; is made.
0801 8013              ; 
0802 8013                       DSect OrigDirect+2 
0803 8013              rtsadr   word 
0804 8013              xOrigD   word 
0805 8013              xDAPtr   long 
0806 8013              xDAHandle long 
0807 8013              xret1    block 3 
0808 8013              xret2    block 3 
0809 8013              Dwhat    word 
0810 8013              Dmessage long 
0811 8013              Dwhen    long 
0812 8013              Dwhere   long 
0813 8013              Dmods    word 
0814 8013              Dresult  word 
0815 8013
0816 8013
0817 8013 A9 00 00     Ignore   lda   #0
0818 8016 60                    rts   
0819 8017
0820 8017              DoIfWantsKey  
0821 8017              ; This routine tests the event to see if its a keydown that might have menu implications
0822 8017              ; If it does this routine will deny that the event belongs to that NDA
0823 8017              ; This will allow NDA's to handle the cut/copy/paste menu items properly
0824 8017 A5 07                 lda   DAHandle
0825 8019 A4 09                 ldy   DAHandle+2
0826 801B
0827 801B 20 FE 81              jsr   StartNDACall
0828 801E A0 04 00              ldy   #4
0829 8021 B7 15                 lda   [NDAListHandle],y
0830 8023 10 03                 bpl   @1
0831 8025 82 37 00              brl   reallyNo
0832 8028              @1        
0833 8028 20 BE 81              jsr   DerefNDAList
0834 802B
0835 802B 20 AE 84              jsr   AreWeTop
0836 802E 90 2C                 bcc   No
0837 8030 20 66 83              jsr   TestMenuKey
0838 8033 90 18                 bcc   DIW0010
0839 8035 80 25                 bra   no                       ; if carry set don't handle it! 
0840 8037
0841 8037 A5 07        DoIfWants lda   DAHandle
0842 8039 A4 09                 ldy   DAHandle+2
0843 803B
0844 803B 20 FE 81              jsr   StartNDACall
0845 803E A0 04 00              ldy   #4
0846 8041 B7 15                 lda   [NDAListHandle],y
0847 8043 30 1A                 bmi   reallyNo
0848 8045 20 BE 81              jsr   DerefNDAList
0849 8048
0850 8048 20 AE 84              jsr   AreWeTop
0851 804B 90 0F                 bcc   No
0852 804D              DIW0010   
0853 804D A5 2D                 lda   Dwhat
0854 804F 0A                    asl   a
0855 8050 AA                    tax   
0856 8051 BF 6F 83 02           lda   >MaskTable,x
0857 8055 A0 14 00              ldy   #o_EventMask
0858 8058 37 09                 and   [PtrToThisOne],y
0859 805A D0 3A                 bne   SendItOn
0860 805C
0861 805C
0862 805C 20 DC 81     No       jsr   UnlockNDAList
0863 805F 20 12 82     ReallyNo jsr   EndNDACall
0864 8062
0865 8062 A9 00 00              lda   #0
0866 8065 60                    rts   
0867 8066
0868 8066              ;----------------------------------------------------
0869 8066              ; This routine tests the keyboard event for menu keyness...
0870 8066              ;
0871 8066              TestMenuKey  
0872 8066 A5 3B                 lda   Dmods
0873 8068 29 00 01              and   #$0100                   ; see if the apple key is down....
0874 806B              ;	bne	@Keeptrying
0875 806B 18                    clc                            ; say not menu key...
0876 806C 60                    rts   
0877 806D
0878 806D              @KeepTrying  
0879 806D              ; for this release , no command keys for DA's
0880 806D 38                    sec   
0881 806E 60                    rts   
0882 806F
0883 806F
0884 806F              ;----------------------------------------------------
0885 806F              ;
0886 806F              ; events greater than 9 are not passed on.
0887 806F              ;
0888 806F 01 00        MaskTable DC W:%0000000000000001        ; 0
0889 8071 02 00                 DC W:%0000000000000010         ; 1
0890 8073 04 00                 DC W:%0000000000000100         ; 2
0891 8075 08 00                 DC W:%0000000000001000         ; 3
0892 8077 10 00                 DC W:%0000000000010000         ; 4
0893 8079 20 00                 DC W:%0000000000100000         ; 5
0894 807B 40 00                 DC W:%0000000001000000         ; 6
0895 807D 80 00                 DC W:%0000000010000000         ; 7
0896 807F 00 01                 DC W:%0000000100000000         ; 8
0897 8081 00 02                 DC W:%0000001000000000         ; 9
0898 8083
0899 8083              DoActivate                              ;
0900 8083              DoUpdate                                ;
0901 8083 A5 07                 lda   DAHandle                 ; set a and y registers before
0902 8085 A4 09                 ldy   DAHandle+2               ; calling StartNDACall
0903 8087 20 FE 81              jsr   StartNDACall
0904 808A 20 BE 81              jsr   DerefNDAList
0905 808D
0906 808D A5 2F                 lda   DMessage
0907 808F A6 31                 ldx   DMessage+2
0908 8091 20 12 84              jsr   FindThisWindow
0909 8094 90 C6                 bcc   No
0910 8096
0911 8096
0912 8096 20 BC 84     SendItOn jsr   SetResID
0913 8099
0914 8099 7B                    tdc   
0915 809A 18                    clc   
0916 809B 69 2D 00              adc   #DWhat
0917 809E AA                    tax   
0918 809F A0 00 00              ldy   #0
0919 80A2 A9 01 00              lda   #DAEventCode
0920 80A5 22 2B 85 02           jsl   SendAction
0921 80A9
0922 80A9 20 E7 84              jsr   RepResID
0923 80AC
0924 80AC
0925 80AC 20 DC 81              jsr   UnlockNDAList
0926 80AF 20 12 82              jsr   EndNDACall
0927 80B2
0928 80B2 A9 00 80              lda   #$8000
0929 80B5 60                    rts   
0930 80B6
0931 80B6
0932 80B6                       ENDP 
0933 80B6
0934 80B6
0935 80B6              ****************************************************************
0936 80B6              *
0937 80B6              * CallCDAMenu
0938 80B6              *
0939 80B6              * This routine is almost identical to the daHandle routine
0940 80B6              * in rom except that we know that we did not get here from
0941 80B6              * an interrupt so interrupt processing code was removed.
0942 80B6              *
0943 80B6              * Also, since this is called through system event, we know
0944 80B6              * that there is no need for scheduling.
0945 80B6              *
0946 80B6              * This routine is called in full native mode (the routine
0947 80B6              * in rom was called in 8 bit mode).
0948 80B6              *
0949 80B6              * There is no information returned by this routine.
0950 80B6              *
0951 80B6              * Change History
0952 80B6              *
0953 80B6              * 01 Oct 87         Steven Glass
0954 80B6              *
0955 80B6              * This routine used in-line storage to preserve the data
0956 80B6              * bank.  It now uses the stack.
0957 80B6              *
0958 80B6              ****************************************************************
0959 80B6              CallCDAMenu PROC EXPORT 
0960 80B6
0961 80B6 8B                    phb                            ; save dbr on stack before anything happens
0962 80B7
0963 80B7 3B                    tsc                            ; save stack for integer basic
0964 80B8 8F 9C 1D E0           sta   >stacksv
0965 80BC
0966 80BC 8B                    phb                            ; stack is saved as $E0/0300
0967 80BD A2 00 01              ldx   #$0100
0968 80C0 A0 00 03              ldy   #$0300
0969 80C3 A9 FF 00              lda   #$FF
0970 80C6 54 E0 00              mvn   $000000,$E00000
0971 80C9
0972 80C9 AB                    plb   
0973 80CA
0974 80CA A9 FB 01              lda   #$1FB                    ; make sure there's room on stack
0975 80CD 1B                    tcs   
0976 80CE
0977 80CE A2 05 0B 22           _saveall                       ; save everything
0978 80D5 A2 05 11 22           _choosecda                     ; display the list of da's
0979 80DC A2 05 0C 22           _restall                       ; unsave everything
0980 80E3
0981 80E3 A2 00 03              ldx   #$0300
0982 80E6 A0 00 01              ldy   #$0100
0983 80E9 A9 FF 00              lda   #$FF
0984 80EC 54 00 E0              mvn   $E00000,$000000
0985 80EF
0986 80EF AF 9C 1D E0           lda   >stacksv
0987 80F3 1B                    tcs   
0988 80F4
0989 80F4 AB                    plb                            ; restore dbr saved first thing.
0990 80F5
0991 80F5 6B                    rtl   
0992 80F6
0993 80F6
0994 80F6                       ENDP 
0995 80F6
0996 80F6
0997 80F6
0998 80F6
0999 80F6              ****************************************************************
1000 80F6              *
1001 80F6              * DoCloseStuff
1002 80F6              *
1003 80F6              * This is a routine that is shared by CloseNDA and
1004 80F6              * by SystemClick for close the NDAs.
1005 80F6              *
1006 80F6              *
1007 80F6              * Change History
1008 80F6              *
1009 80F6              * 02 Oct 87         Steven Glass
1010 80F6              *
1011 80F6              * No changes required to support new data structures.
1012 80F6              *
1013 80F6              ****************************************************************
1014 80F6              DoCloseStuff PROC EXPORT 
1015 80F6 20 BC 84              jsr   SetResID
1016 80F9
1017 80F9 22 19 85 02           jsl   SendClose
1018 80FD
1019 80FD 20 E7 84              jsr   RepResID
1020 8100
1021 8100 A0 1A 00              ldy   #o_WindowPtr
1022 8103 A9 00 00              lda   #0
1023 8106 97 09                 sta   [PtrToThisOne],y
1024 8108 C8                    iny   
1025 8109 C8                    iny   
1026 810A 97 09                 sta   [PtrToThisOne],y
1027 810C
1028 810C A9 00 00              lda   #0                       ; the the status word
1029 810F 87 09                 sta   [PtrToThisOne]
1030 8111
1031 8111 60                    rts   
1032 8112
1033 8112                       ENDP 
1034 8112
1035 8112
1036 8112
1037 8112              ****************************************************************
1038 8112              *
1039 8112              * FindThisWindow
1040 8112              *
1041 8112              * Inputs
1042 8112              *       a-reg:  low word of window ptr to look for
1043 8112              *       x-reg:  high word of window ptr to look for
1044 8112              *
1045 8112              * Outputs:
1046 8112              *   carry:  set if window is found
1047 8112              *           clear if window is not found
1048 8112              *   DPage:
1049 8112              *     OffsetToThisOne & PtrToThisOne set to point into
1050 8112              *     global data.
1051 8112              *
1052 8112              * We search through the NDAList for an NDA with a window ptr
1053 8112              * equal to the one passed in the a and x register.
1054 8112              *
1055 8112              * If we find it, we return with the carry set and the
1056 8112              * variables OffsetToThisOne and PtrToThisOne set on zero page.
1057 8112              *
1058 8112              * If we do not find it we return with carry clear.
1059 8112              *
1060 8112              * 
1061 8112              * Change History
1062 8112              *
1063 8112              * 02 Oct 87         Steven Glass
1064 8112              *
1065 8112              * Changes were made to get this to work with new global data
1066 8112              * structures.
1067 8112              *
1068 8112              ****************************************************************
1069 8112              FindThisWindow PROC EXPORT 
1070 8112
1071 8112 DA                    phx                            ; store the pointer on the stack
1072 8113 48                    pha                            ;
1073 8114
1074 8114              *** added 19-Feb-91 DAL
1075 8114 8F AA 84 02           sta   >DeskGlobalWindow
1076 8118 8A                    txa   
1077 8119 8F AC 84 02           sta   >DeskGlobalWindow+2
1078 811D              *** end of 19-Feb-91 DAL
1079 811D
1080 811D A0 0E 00              ldy   #SizeOfDeskGlobals       ; y points to first NDA record
1081 8120 A2 01 00              ldx   #1                       ; x is count
1082 8123
1083 8123 8A           KeepLooking txa                         ; compare count to num scrap records
1084 8124 C7 01                 cmp   [NDAListPtr]
1085 8126 F0 02                 beq   LastItem
1086 8128 B0 37                 bcs   NotInTable
1087 812A
1088 812A 98           LastItem tya   
1089 812B 18                    clc   
1090 812C 69 1A 00              adc   #o_WindowPtr
1091 812F A8                    tay   
1092 8130 B7 01                 lda   [NDAListPtr],y           ; get the type of this scrap record
1093 8132 C8                    iny                            ; bump y before compare
1094 8133 C8                    iny   
1095 8134 C3 01                 cmp   1,s                      ; compare to value on stack
1096 8136 D0 06                 bne   NotThisOne
1097 8138 B7 01                 lda   [NDAListPtr],y
1098 813A C3 03                 cmp   3,s
1099 813C F0 09                 beq   FoundIt
1100 813E
1101 813E 98           NotThisOne tya                          ; bump y by size of record
1102 813F 18                    clc                            ; minus what we've already bumped
1103 8140 69 08 00              adc   #NDARecSize-o_WindowPtr-2
1104 8143 A8                    tay   
1105 8144 E8                    inx                            ; bump count by 1
1106 8145 80 DC                 bra   KeepLooking
1107 8147
1108 8147
1109 8147 68           FoundIt  pla                            ; clear pointer off stack
1110 8148 68                    pla   
1111 8149 98                    tya                            ; fix Offset To this one by subtracting
1112 814A 38                    sec                            ; off the extra we just added to get to
1113 814B E9 1C 00              sbc   #o_WindowPtr+2           ; window ptr.
1114 814E 85 05                 sta   OffsetToThisOne
1115 8150 64 07                 stz   OffsetToThisOne+2
1116 8152 A5 01                 lda   NDAListPtr
1117 8154 18                    clc   
1118 8155 65 05                 adc   OffsetToThisOne
1119 8157 85 09                 sta   PtrToThisOne
1120 8159 A5 03                 lda   NDAListPtr+2
1121 815B 65 07                 adc   OffsetToThisOne+2
1122 815D 85 0B                 sta   PtrToThisOne+2
1123 815F 38                    sec   
1124 8160 60                    rts   
1125 8161
1126 8161              *** 19-Feb-91 DAL
1127 8161              *** Call GetAuxWindInfo and grab a pointer to the NDA-like structure from there, if any.
1128 8161              *** Window pointer is still on stack.
1129 8161
1130 8161 FA           NotInTable plx   
1131 8162 68                    pla   
1132 8163 5A                    phy   
1133 8164 5A                    phy                            ;space for GetAuxWindInfo result
1134 8165 48                    pha   
1135 8166 DA                    phx                            ;pushed window pointer
1136 8167
1137 8167              ;	pha		;space for GetWKind result
1138 8167              ;	pha
1139 8167              ;	phx		;pushed second copy of window pointer
1140 8167              ;	_GetWKind
1141 8167              ;	pla
1142 8167              ;	bpl	@appWindow
1143 8167              *** 16-Apr-91 DAL -- calling GetWKind trashes some WM direct page, so look in the record directly
1144 8167              *** (the system-window bit is bit 31 of the window's port's pixelMap pointer!)
1145 8167 0B                    phd   
1146 8168 48                    pha   
1147 8169 DA                    phx   
1148 816A 3B                    tsc   
1149 816B 5B                    tcd   
1150 816C A0 04 00              ldy   #4
1151 816F B7 01                 lda   [1],y
1152 8171 FA                    plx   
1153 8172 FA                    plx   
1154 8173 2B                    pld   
1155 8174 AA                    tax   
1156 8175 10 2D                 bpl   @appWindow
1157 8177              *** end of 16-Apr-91 DAL
1158 8177
1159 8177 A2 0E 63 22           _GetAuxWindInfo 
1160 817E 68                    pla   
1161 817F FA                    plx   
1162 8180 B0 26                 bcs   @notfound
1163 8182
1164 8182 0B                    phd   
1165 8183 DA                    phx   
1166 8184 48                    pha   
1167 8185 3B                    tsc   
1168 8186 5B                    tcd   
1169 8187 A0 18 00              ldy   #24                      ;offset into aux wind info of NDAStruct
1170 818A B7 01                 lda   [1],y
1171 818C AA                    tax   
1172 818D C8                    iny   
1173 818E C8                    iny   
1174 818F B7 01                 lda   [1],y                    ;NDAStruct pointer in AX
1175 8191 7A                    ply   
1176 8192 7A                    ply   
1177 8193 2B                    pld   
1178 8194
1179 8194 A8                    tay   
1180 8195 D0 03                 bne   @found
1181 8197 9B                    txy   
1182 8198 F0 0E                 beq   @notfound
1183 819A
1184 819A 85 0B        @found   sta   <PtrToThisOne+2          ;not nil--return it in PtrToThisOne
1185 819C 86 09                 stx   <PtrToThisOne
1186 819E 64 05                 stz   <OffsetToThisOne
1187 81A0 64 07                 stz   <OffsetToThisOne+2       ;make sure nobody's using this!
1188 81A2 38                    sec   
1189 81A3 60                    rts   
1190 81A4
1191 81A4 68           @appWindow pla   
1192 81A5 68                    pla   
1193 81A6 68                    pla   
1194 81A7 68                    pla   
1195 81A8 18           @notfound clc   
1196 81A9 60                    rts   
1197 81AA
1198 81AA                       export DeskGlobalWindow 
1199 81AA 00 00 00 00  DeskGlobalWindow DC L:0
1200 81AE
1201 81AE                       ENDP 
1202 81AE
1203 81AE              ****************************************************************
1204 81AE              *
1205 81AE              * AreWeTop
1206 81AE              *
1207 81AE              * Decides if the top window is a system window.  If it is
1208 81AE              * then AreWeTop returns with carry set.  If the top window
1209 81AE              * is not a system window, then AreWeTop returns with carry
1210 81AE              * clear.
1211 81AE              *
1212 81AE              * Additionally, if the window is a system window, I call
1213 81AE              * find this window which sets up PtrToThisOne.  FindThisWindow
1214 81AE              * must also succeed for AreWeTop to return true.
1215 81AE              *
1216 81AE              *
1217 81AE              * Change History
1218 81AE              *
1219 81AE              * 02 Oct 87         Steven Glass
1220 81AE              *
1221 81AE              * No changes were needed for new data structures but
1222 81AE              * I changed a PushLong #0 to pha pha to save space.
1223 81AE              *
1224 81AE              * 15 mar 89         Steven Glass
1225 81AE              *
1226 81AE              * Uses FrontToAX instead of calling FrontWindow directly
1227 81AE              * saving lots of code.
1228 81AE              *
1229 81AE              * Also branch directly to FindThisWindow rather than
1230 81AE              * jsr followed by rts.  This saves more code.
1231 81AE              *
1232 81AE              ****************************************************************
1233 81AE              AreWeTop PROC EXPORT 
1234 81AE
1235 81AE
1236 81AE 20 5A 85              jsr   FrontToAX
1237 81B1 A8                    tay   
1238 81B2 D0 05                 bne   FindthisWindow0
1239 81B4 9B                    txy   
1240 81B5 D0 02                 bne   FindThisWindow0
1241 81B7
1242 81B7 18           NotSystem clc   
1243 81B8 60                    rts   
1244 81B9
1245 81B9 82 56 FF     FindThisWindow0 brl   FindThisWindow    ;DAL
1246 81BC
1247 81BC                       ENDP 
1248 81BC
1249 81BC
1250 81BC              ****************************************************************
1251 81BC              *
1252 81BC              FutzResIDs proc 
1253 81BC              *
1254 81BC              * Two routines here are used to set and restore the Resource
1255 81BC              * Manager's current Resource App.
1256 81BC              *
1257 81BC              * These calls are meant to be made around calls to the
1258 81BC              * NDA.  Example:
1259 81BC              *
1260 81BC              *                   jsr SetResID
1261 81BC              *                   send msg to NDA
1262 81BC              *                   jsr RepResID
1263 81BC              *
1264 81BC              * The first call puts the current resID on the stack,
1265 81BC              * The second call pulls it off.
1266 81BC              *
1267 81BC              *
1268 81BC              * Inputs:
1269 81BC              *                   none
1270 81BC              *
1271 81BC              * Outputs:
1272 81BC              *                   none
1273 81BC              *
1274 81BC              * External Refs:
1275 81BC              *                   none
1276 81BC              *
1277 81BC              * Entry Points:
1278 81BC                       Export SetResID 
1279 81BC                       Export RepResID 
1280 81BC              *
1281 81BC                       longa on                       ; mode
1282 81BC                       longi on
1283 81BC              *
1284 81BC              * Change History
1285 81BC              *
1286 81BC              * 01 Mar 89         Steven Glass & Harry Yee
1287 81BC              *
1288 81BC              * Harry scolds steve and tells him that you cannot call the 
1289 81BC              * resource manager and expect it to work, if the resource 
1290 81BC              * manager is not there.
1291 81BC              *
1292 81BC              * No disk other that 4.1 worked at all.
1293 81BC              *
1294 81BC              ****************************************************************
1295 81BC
1296 81BC FA           SetResID plx                            ; make room on the stack above
1297 81BD 48                    pha                            ; the rts
1298 81BE DA                    phx   
1299 81BF
1300 81BF F4 00 00              pea   0                        ; call resource status
1301 81C2 A2 1E 06 22           _ResourceStatus 
1302 81C9 68                    pla                            ; get result in a-reg
1303 81CA B0 1A                 bcs   @Done                    ; carry set means got dispatch error
1304 81CC F0 18                 beq   @Done                    ; 0 means resource manager not active
1305 81CE
1306 81CE 48                    pha                            ; get the current res app id
1307 81CF A2 1E 14 22           _GetCurResourceApp 
1308 81D6 68                    pla   
1309 81D7 83 03                 sta   3,s                      ; put it on the stack above the RTS
1310 81D9
1311 81D9 A0 22 00              ldy   #o_UserID                ; set the id of the NDA about to be called
1312 81DC B7 09                 lda   [PtrToThisOne],y
1313 81DE 48                    pha   
1314 81DF A2 1E 13 22           _SetCurResourceApp 
1315 81E6
1316 81E6 60           @Done    rts                            ; done
1317 81E7
1318 81E7
1319 81E7
1320 81E7
1321 81E7 FA           RepResID plx                            ; pull off the old ID and put back
1322 81E8 68                    pla   
1323 81E9 DA                    phx                            ; the rts addr
1324 81EA 48                    pha                            ; save id on this side of rts adr
1325 81EB
1326 81EB F4 00 00              pea   0                        ; call status
1327 81EE A2 1E 06 22           _ResourceStatus 
1328 81F5 68                    pla                            ; get status result
1329 81F6 FA                    plx                            ; get id off stack
1330 81F7 A8                    tay                            ; set the zero bit of processor
1331 81F8 B0 0A                 bcs   @Done
1332 81FA F0 08                 beq   @Done
1333 81FC
1334 81FC
1335 81FC
1336 81FC DA                    phx                            ; push id now in x-reg
1337 81FD A2 1E 13 22           _SetCurResourceApp 
1338 8204
1339 8204 60           @Done    rts                            ; done.
1340 8205
1341 8205                       ENDP 
1342 8205
1343 8205
1344 8205              ****************************************************************
1345 8205              *
1346 8205              SendOpen PROC EXPORT 
1347 8205              *
1348 8205              * This routine transfers control to the open routine of the
1349 8205              * DA pointed to by PointerToThisOne.  All registers and
1350 8205              * relative stack locations are preserved.  Control returns
1351 8205              * from the DA to the Calling routine, not here.
1352 8205              *
1353 8205              *
1354 8205              *
1355 8205              * Inputs:
1356 8205              *                   a, x and y are all passed on to the NDA
1357 8205              *                   unchanged.
1358 8205              *
1359 8205              * Outputs:
1360 8205              *                   none
1361 8205              *
1362 8205              * External Refs:
1363 8205              *                   none
1364 8205              *
1365 8205              * Entry Points:
1366 8205                       ENTRY SendSomething 
1367 8205              *
1368 8205                       longa on                       ; mode
1369 8205                       longi on
1370 8205              *
1371 8205              * Change History
1372 8205              *
1373 8205              * 02 Oct 87         Steven Glass
1374 8205              *
1375 8205              * No chnages were necessary to support the new data structures.
1376 8205              *
1377 8205              * 19 Feb 89         Steven Glass
1378 8205              *
1379 8205              * All the send routines ended the same way, so they now 
1380 8205              * share code with SendOpen.  The new entry point is SendSomething.
1381 8205              *
1382 8205              ****************************************************************
1383 8205
1384 8205
1385 8205              s_YReg   equ   1
1386 8205              s_AReg   equ   3
1387 8205              s_AdrForOpen equ   5
1388 8205
1389 8205 48                    pha                            ; put 3 bytes on stack
1390 8206 8B                    phb                            ; for addr of action routine
1391 8207
1392 8207 48                    pha                            ; save a
1393 8208 5A                    phy                            ; save y
1394 8209
1395 8209 A0 03 00              ldy   #o_Open+1                ; get addr from table
1396 820C
1397 820C              SendSomething  
1398 820C B7 09                 lda   [PtrToThisOne],y
1399 820E 83 06                 sta   s_AdrForOpen+1,s
1400 8210 88                    dey   
1401 8211 B7 09                 lda   [PtrToThisOne],y         ; rtl adds 1 so sub 1
1402 8213 3A                    dec   a
1403 8214 83 05                 sta   s_AdrForOpen,s
1404 8216
1405 8216 7A                    ply   
1406 8217 68                    pla   
1407 8218
1408 8218 6B                    rtl   
1409 8219
1410 8219                       ENDP 
1411 8219
1412 8219
1413 8219              ****************************************************************
1414 8219              *
1415 8219              * SendClose
1416 8219              *
1417 8219              * This routine transfers control to the close routine of the
1418 8219              * DA pointed to by PointerToThisOne.  All registers and
1419 8219              * relative stack locations are preserved.  Control returns
1420 8219              * from the DA to the Calling routine, not here.
1421 8219              *
1422 8219              *
1423 8219              *
1424 8219              * Change History
1425 8219              *
1426 8219              * 02 Oct 87         Steven Glass
1427 8219              *
1428 8219              * No chnages were necessary to support the new data structures.
1429 8219              *
1430 8219              ****************************************************************
1431 8219              SendClose PROC EXPORT 
1432 8219
1433 8219              s_YReg   equ   1
1434 8219              s_AReg   equ   3
1435 8219              s_AdrForClose equ   5
1436 8219
1437 8219 48                    pha                            ; put 3 bytes on stack
1438 821A 8B                    phb                            ; for addr of action routine
1439 821B
1440 821B 48                    pha                            ; save a
1441 821C 5A                    phy                            ; save y
1442 821D
1443 821D A0 07 00              ldy   #o_Close+1               ; get addr from table
1444 8220 80 EA                 bra   SendSomething
1445 8222
1446 8222                       ENDP 
1447 8222
1448 8222
1449 8222              ****************************************************************
1450 8222              *
1451 8222              * SendInit
1452 8222              *
1453 8222              * This routine transfers control to the init routine of the
1454 8222              * DA pointed to by PointerToThisOne.  All registers and
1455 8222              * relative stack locations are preserved.  Control returns
1456 8222              * from the DA to the Calling routine, not here.
1457 8222              *
1458 8222              *
1459 8222              *
1460 8222              * Change History
1461 8222              *
1462 8222              * 02 Oct 87         Steven Glass
1463 8222              *
1464 8222              * No chnages were necessary to support the new data structures.
1465 8222              *
1466 8222              ****************************************************************
1467 8222              SendInit PROC EXPORT 
1468 8222
1469 8222              s_YReg   equ   1
1470 8222              s_AReg   equ   3
1471 8222              s_AdrForInit equ   5
1472 8222
1473 8222 48                    pha                            ; put 3 bytes on stack
1474 8223 8B                    phb                            ; for addr of action routine
1475 8224
1476 8224 48                    pha                            ; save a
1477 8225 5A                    phy                            ; save y
1478 8226
1479 8226 A0 0F 00              ldy   #o_Init+1                ; get addr from table
1480 8229 80 E1                 bra   SendSomething
1481 822B
1482 822B                       ENDP 
1483 822B
1484 822B
1485 822B              ****************************************************************
1486 822B              *
1487 822B              * SendAction
1488 822B              *
1489 822B              * Inputs
1490 822B              *    All-registers
1491 822B              *    PtrToThisOne
1492 822B              *
1493 822B              * Output
1494 822B              *    Depends on routine called.
1495 822B              *
1496 822B              * This routine transfers control to the action routine of the
1497 822B              * DA pointed to by PointerToThisOne.  All registers and
1498 822B              * relative stack locations are preserved.  Control returns
1499 822B              * from the DA to the Calling routine, not here.
1500 822B              *
1501 822B              *
1502 822B              * Change History
1503 822B              *
1504 822B              * 02 Oct 87         Steven Glass
1505 822B              *
1506 822B              * No chnages were necessary to support the new data structures.
1507 822B              *
1508 822B              ****************************************************************
1509 822B              SendAction PROC EXPORT 
1510 822B
1511 822B              s_YReg   equ   1
1512 822B              s_AReg   equ   3
1513 822B              s_AdrForAction equ   5
1514 822B
1515 822B 48                    pha                            ; put 3 bytes on stack
1516 822C 8B                    phb                            ; for addr of action routine
1517 822D
1518 822D 48                    pha                            ; save a
1519 822E 5A                    phy                            ; save y
1520 822F
1521 822F              *** 26-Jun-92 DAL -- Add stack-based dispatch option.  Set bit 31 of action pointer.
1522 822F              ;	ldy	#o_Action+1	; get addr from table
1523 822F              ;;	bra	SendSomething
1524 822F              ;;SendSomething	lda	[PtrToThisOne],y
1525 822F              ;	sta	s_AdrForOpen+1,s
1526 822F              ;	dey
1527 822F              ;	lda	[PtrToThisOne],y ; rtl adds 1 so sub 1
1528 822F              ;	dec	a
1529 822F              ;	sta	s_AdrForOpen,s
1530 822F              ;
1531 822F              ;	ply
1532 822F              ;	pla
1533 822F              ;
1534 822F              ;	rtl
1535 822F
1536 822F A0 0C 00              ldy   #o_Action+2              ; get address from table
1537 8232 B7 09                 lda   [<PtrToThisOne],y
1538 8234 30 03                 bmi   @stack_dispatch
1539 8236 88                    dey                            ; Y = o_Action+1
1540 8237 80 D3                 bra   SendSomething            ; old way
1541 8239
1542 8239              *** A = code, YX = data value (sometimes event pointer)
1543 8239
1544 8239 7A           @stack_dispatch ply   
1545 823A 68                    pla   
1546 823B
1547 823B              *** strip 3 extra bytes off stack (we pushed them at beginning of SendAction)
1548 823B 83 02                 sta   2,s
1549 823D 8B                    phb   
1550 823E 68                    pla   
1551 823F 68                    pla   
1552 8240
1553 8240 F4 00 00              pea   0                        ;push result space
1554 8243 48                    pha                            ;action code
1555 8244 5A                    phy   
1556 8245 DA                    phx                            ;data/pointer
1557 8246 22 4C 85 02           jsl   @jump_action
1558 824A 68                    pla                            ;get result into A
1559 824B 6B                    rtl   
1560 824C
1561 824C A0 0B 00     @jump_action ldy   #o_Action+1
1562 824F B7 09                 lda   [<PtrToThisOne],y
1563 8251 48                    pha   
1564 8252 8B                    phb   
1565 8253 88                    dey   
1566 8254 B7 09                 lda   [<PtrToThisOne],y
1567 8256 3A                    dec   a
1568 8257 83 01                 sta   1,s
1569 8259 6B                    rtl   
1570 825A              *** end 26-Jun-92
1571 825A
1572 825A                       ENDP 
1573 825A
1574 825A
1575 825A              ****************************************************************
1576 825A              *
1577 825A              FrontToAX PROC export 
1578 825A              *
1579 825A              * Returns the pointer to the front window to in the A & X 
1580 825A              * registers.
1581 825A              *
1582 825A              *
1583 825A              * Inputs:
1584 825A              *                   none
1585 825A              *
1586 825A              * Outputs:
1587 825A              *                   a-reg
1588 825A              *                   x-reg
1589 825A              *
1590 825A              * External Refs:
1591 825A              *                   none
1592 825A              *
1593 825A              * Entry Points:
1594 825A              *                   none
1595 825A              *
1596 825A                       longa on                       ; mode
1597 825A                       longi on
1598 825A              *
1599 825A              ****************************************************************
1600 825A 48                    pha   
1601 825B 48                    pha   
1602 825C A2 0E 15 22           _FrontWindow 
1603 8263 68                    pla   
1604 8264 FA                    plx   
1605 8265 60                    rts   
1606 8266
1607 8266                       ENDP 
1608 8266
1609 8266                       END   
